<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// جلب الإعدادات الحالية
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}

// تحديث الإعدادات
if (isset($_POST['save_settings'])) {
    $fields = [
        'company_name', 'email', 'phone', 'whatsapp', 'work_hours', 'address', 'main_color', 'secondary_color', 'bg_color', 'text_color'
    ];
    foreach ($fields as $key) {
        $value = trim($_POST[$key] ?? '');
        $stmt = $pdo->prepare('INSERT INTO settings (key_name, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value)');
        $stmt->execute([$key, $value]);
    }
    // رفع الشعار
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        $allowed = ['png','jpg','jpeg','gif'];
        if (in_array($ext, $allowed)) {
            $filename = 'logo.'.$ext;
            $target = '../assets/'.$filename;
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
                $stmt = $pdo->prepare('INSERT INTO settings (key_name, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value)');
                $stmt->execute(['logo', $filename]);
            }
        }
    }
    header('Location: settings.php');
    exit;
}

?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الإعدادات العامة</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 700px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        label { color: #3A4750; font-weight: bold; }
        input, textarea { width: 100%; padding: 8px; margin-bottom: 16px; border: 1px solid #EA9218; border-radius: 4px; }
        button { background: #EA9218; color: #fff; border: none; padding: 10px 24px; border-radius: 4px; width: 100%; font-size: 16px; }
        .logo-preview { display: block; margin: 0 auto 16px; max-width: 120px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>الإعدادات العامة</h2>
        <form method="post" enctype="multipart/form-data">
            <label>اسم الشركة</label>
            <input type="text" name="company_name" value="<?= htmlspecialchars($settings['company_name'] ?? '') ?>">
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" value="<?= htmlspecialchars($settings['email'] ?? '') ?>">
            <label>رقم الهاتف</label>
            <input type="text" name="phone" value="<?= htmlspecialchars($settings['phone'] ?? '') ?>">
            <label>واتساب</label>
            <input type="text" name="whatsapp" value="<?= htmlspecialchars($settings['whatsapp'] ?? '') ?>">
            <label>أوقات العمل</label>
            <input type="text" name="work_hours" value="<?= htmlspecialchars($settings['work_hours'] ?? '') ?>">
            <label>عنوان الشركة</label>
            <textarea name="address"><?= htmlspecialchars($settings['address'] ?? '') ?></textarea>
            <label>الشعار الحالي</label>
            <?php if (!empty($settings['logo'])): ?>
                <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" class="logo-preview" alt="شعار الشركة">
            <?php endif; ?>
            <input type="file" name="logo">
            <label>اللون الأساسي</label>
            <input type="color" name="main_color" value="<?= htmlspecialchars($settings['main_color'] ?? '#EA9218') ?>">
            <label>اللون الثانوي</label>
            <input type="color" name="secondary_color" value="<?= htmlspecialchars($settings['secondary_color'] ?? '#3A4750') ?>">
            <label>لون الخلفية</label>
            <input type="color" name="bg_color" value="<?= htmlspecialchars($settings['bg_color'] ?? '#EEEEEE') ?>">
            <label>لون النص</label>
            <input type="color" name="text_color" value="<?= htmlspecialchars($settings['text_color'] ?? '#313841') ?>">
            <button type="submit" name="save_settings">حفظ الإعدادات</button>
        </form>
    </div>
</body>
</html>
